/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DumpCommand {
    private static final DynamicCommandExceptionType ERROR_REGISTRY_NOT_FOUND = new DynamicCommandExceptionType(registry -> Component.translatableWithFallback((String)"commands.securitycraft.dump.notFound", (String)"SecurityCraft has nothing registered to \"%s\".", (Object[])new Object[]{registry}));
    private static final Map<String, DeferredRegister<?>> REGISTRIES = (Map)Util.make(() -> {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (Field field : SCContent.class.getFields()) {
            try {
                Object object = field.get(null);
                if (!(object instanceof DeferredRegister)) {
                    return map;
                }
                map.put(field.getName().toLowerCase(Locale.ROOT), (DeferredRegister)object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return map;
    });

    private DumpCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"dump").then(Commands.argument((String)"registry", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(REGISTRIES.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> {
            String registry = (String)ctx.getArgument("registry", String.class);
            if (!REGISTRIES.containsKey(registry)) {
                throw ERROR_REGISTRY_NOT_FOUND.create((Object)registry);
            }
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            String lineSeparator = System.lineSeparator();
            Collection registryObjects = REGISTRIES.get(registry).getEntries();
            Object result = "";
            for (DeferredHolder ro : registryObjects) {
                result = (String)result + ro.getId().toString() + lineSeparator;
            }
            String finalResult = ((String)result).substring(0, ((String)result).lastIndexOf(lineSeparator));
            if (source.isPlayer()) {
                source.sendSuccess(() -> Component.literal((String)"[").append((Component)Component.literal((String)"SecurityCraft").withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)"] ")).append((Component)Component.translatable((String)"commands.securitycraft.dump.result", (Object[])new Object[]{registryObjects.size()}).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)registry))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, finalResult)))), true);
            } else {
                source.sendSuccess(() -> Component.literal((String)finalResult), true);
            }
            return 0;
        }));
    }
}

